<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('from_user_id');
            $table->foreign('from_user_id')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->unsignedBigInteger('to_user_id');
            $table->foreign('to_user_id')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->string('content');
            $table->string('route');
            // notification types
            # 0=> default
            # 1=> بدء التعلم
            # 2=>  اسناد برنامج لمشرف
            # 3=>  انضمام للبرنامج
            # 4=>  ملحق جديد للبرنامج
            # 5=>  إنشاء اختبار 
            # 6=>  رفع اختبار 
            # 7=>  إنشاء استبيان 
            # 8=>  رفع استبيان 
            # 9=> الحصول على الشهادة
            $table->integer('type')->default(0);
            $table->smallInteger('is_seen')->default(-1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
};
